import java.io.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

public class AddDom {

  private String indentation = ". ";
  private Document doc;
  private Element root;

  public void doit(String filename) {
    try {
      File file = new File(filename);
      DocumentBuilderFactory factory =
        DocumentBuilderFactory.newInstance();
      DocumentBuilder builder =
        factory.newDocumentBuilder();
      doc = builder.parse( file );
      root = doc.getDocumentElement();
      System.out.println("old version:");
      showElements(root, 1);
      addPerson("Richard", "Wagner", 1813, 0.0);
      System.out.println("new version:");
      showElements(root, 1);
    } catch (Exception e) {
        System.out.println(e);
    }
  }

  public void showElements(Node node, int level) {
    // called recursively, starting with root
    if (node instanceof Text) {
      String s = node.getNodeValue().trim();
      if (s.length()>0) {
        for (int i=1; i<=level; i++) {
          System.out.print(indentation);
        }
        System.out.println("= " + s);
      }
    } else {
      for (int i=1; i<=level; i++) {
        System.out.print(indentation);
      }
      System.out.println(node.getNodeName());
    }
    NodeList children = node.getChildNodes();
    for (int i=0; i<children.getLength(); i++) {
      showElements( children.item(i), level+1 );
      // recursive call for next level
    }
  }

  public void addPerson
      (String vorname, String zuname, int gebjahr, double gehalt) {

    Element person = doc.createElement("person");
    root.insertBefore( person, null ); // before null = at end

    Element el;
    Node text;

    el = doc.createElement("vorname");
    person.appendChild(el);
    text = doc.createTextNode( vorname );
    el.appendChild(text);

    el = doc.createElement("zuname");
    person.appendChild(el);
    text = doc.createTextNode( zuname );
    el.appendChild(text);

    el = doc.createElement("gebjahr");
    person.appendChild(el);
    text = doc.createTextNode( String.valueOf(gebjahr) );
    el.appendChild(text);

    el = doc.createElement("gehalt");
    person.appendChild(el);
    text = doc.createTextNode( String.valueOf(gehalt) );
    el.appendChild(text);

  }

  public static void main (String[] args) {
      AddDom prog = new AddDom();
      prog.doit("mitarbeiter.xml");
  }

}
