import java.awt.*;
import java.applet.*;

/**
* an example for an Applet with javadoc documentation,
* Applet info, und parameter info.
* @since JDK 1.0
*/
public class AppletDoc extends Applet {

  String text;
  int fontSize;
  Font f;

  public void init () {
    text = getParameter("text");
    if (text == null)
      text = "Hello World!";
    try {
      fontSize = Integer.parseInt ( 
        getParameter("fontsize").trim() );
    } catch (Exception e) {
        fontSize = 12;
    }
    f = new Font ("Helvetica", Font.BOLD, fontSize);
  }

  public void paint (Graphics g) {
    g.setFont (f);
    g.drawString (text, 25, 50);
  }

  public String getAppletInfo() {
    String s = 
      "AppletDoc = Hello World Applet with parameters";
    return s;
  }
  
  public String[][] getParameterInfo() {
    String[][] s = {
      { "text",     "String",  "Text to be displayed" },
      { "fontsize", "Integer", "Font size in points" }
    };
    return s;
  }
}
