import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.text.*;

public class BankApplet extends Applet {

  private BankModel bankModel;
  private BankController bankController;

  protected Label investLabel, rateLabel, errorLabel, messLabel;
  protected TextField investField, rateField;
  protected BankTable bankTable; 
  protected BankDiagram bankDiagram;
  protected Panel northPanel;
  protected String mess1 = "Enter data and hit return";
  protected String mess2 = "Enter numbers as XXXX.XX";

  public void init () {

    bankModel = new BankModel();
    bankController = new BankController (this, bankModel);

    setLayout (new BorderLayout() );

    // north panel = input fields and labels

    northPanel = new Panel();
    northPanel.setLayout (new GridLayout(3,2) );

    investLabel = new Label("investment in S   ", Label.RIGHT);
    northPanel.add(investLabel);
    investField = new TextField("",12);
    investField.addActionListener( bankController );
    northPanel.add(investField);

    rateLabel = new Label("interest rate in %   ", Label.RIGHT);
    northPanel.add(rateLabel);
    rateField = new TextField("",4);
    rateField.addActionListener( bankController );
    northPanel.add(rateField);

    errorLabel = new Label("                     ", Label.RIGHT);
    errorLabel.setForeground(Color.red);
    northPanel.add(errorLabel);
    messLabel = new Label(mess1, Label.LEFT);
    northPanel.add(messLabel);

    add (northPanel, "North");

    // east = table canvas

    bankTable = new BankTable( bankModel ); 
    add (bankTable, "East");

    // center = diagram canvas

    bankDiagram = new BankDiagram( bankModel );
    add (bankDiagram, "Center");

    setVisible(true);
  }
}
