import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.text.*;

public class BankDiagram extends Canvas {

  private BankModel bankModel;
  private double[] amount;
  private double invest;

  public BankDiagram (BankModel bm) {
    this.bankModel = bm;
  }

  public Dimension getMinimumSize() {
    return new Dimension(120,220);
  }
  public Dimension getPreferredSize() {
    return getMinimumSize();
  }

  public void paint (Graphics g) {

    amount = bankModel.getAmount();
    invest = bankModel.getInvest();

    Dimension mySize = getSize();
    int width = mySize.width;
    int height = mySize.height;
    int x1 = 10;
    int x2 = width - 10;
    int dx = (width - 20) / (amount.length - 1) ;
    int y1 = 10;
    int y2 = height - 10;
    double scale = (2.0*invest) / (double)(y2-y1);
    int[] x = new int [amount.length];
    int[] y = new int [amount.length];

    g.setColor (Color.white);
    g.fillRect (0,0, width,height);

    g.setColor (Color.black);
    g.drawRect (x1,y1, dx*(amount.length-1), y2-y1);
 
     for (int year=0; year<amount.length; year++) {
      x[year] = x1 + year * dx;
      y[year] = y2 - (int)( amount[year]/scale );
    }
    g.setColor (Color.blue);
    g.drawPolyline (x,y, amount.length);
    for (int i=0; i<amount.length; i++) {
      g.drawLine (x[i],y2, x[i],y[i]);
    }
  }
} 
