import java.text.*;

public class BankEx {
  public static void main (String[] args) {
    double invest, rate, factor, amount;
    int numYears;

    DecimalFormat df = new DecimalFormat("#,###,##0.00");
    DecimalFormat intf = new DecimalFormat("00");

    if (args.length != 2) {
      System.out.println ("Usage: java BankEx amount rate");
      System.exit(1);
    }

    try {
      invest = Double.valueOf(args[0]).doubleValue();
      rate = Double.valueOf(args[1]).doubleValue();
      factor = (100.0 + rate) / 100.0;
      numYears = 10;

      System.out.println("Investment =      " +
        df.format(invest) );
      System.out.println("Interest Rate =   " +
        df.format(rate) );

      amount=invest;
      for (int year=1; year<=numYears; year++) {
        amount = amount * factor;
      System.out.println ("Year " + intf.format(year) +
          "   Amount = " + df.format(amount) );
      }
    } catch (Exception e) {
        System.out.println("*** error: " + e);
    }
  }
}
