import java.text.*;

public class BankEx2 {
  public static void main (String[] args) {
    double invest, rate, factor, amount;
    int numYears;
    DecimalFormat df = new DecimalFormat("#,###,##0.00");
    DecimalFormat intf = new DecimalFormat("00");

    try {
      invest = Double.valueOf(args[0]).doubleValue();
    } catch (Exception e) {
      // ArrayIndexOutOfBoundsException or NumberFormatException
      System.out.println("Investment not specified * " + e);
      invest = 1000;
    }

    try {
      rate = Double.valueOf(args[1]).doubleValue();
    } catch (Exception e) {
      // ArrayIndexOutOfBoundsException or NumberFormatException
      System.out.println("Rate not specified * " + e);
      rate = 3.5;
    }

    factor = (100.0 + rate) / 100.0;
    numYears = 10;
    System.out.println("Investment =      " +
      df.format(invest) );
    System.out.println("Interest Rate =   " +
      df.format(rate) );

    amount=invest;
    for (int year=1; year<=numYears; year++) {
      amount = amount * factor;
      System.out.println ("Year " + intf.format(year) +
        "   Amount = " + df.format(amount) );
    }
  }
}
