import java.awt.*;
import java.awt.event.*;
import java.text.*;

public class BankGui extends Frame
  implements ActionListener, WindowListener {

  // Model (data):
  double invest, rate, factor;
  int numYears=10;
  double[] amount = new double[numYears+1];

  // View:
  Label investLabel, rateLabel, errorLabel, messLabel;
  TextField investField, rateField;
  TableCanvas tableCanvas; // defined below
  DiagramCanvas diagramCanvas; // defined below
  Panel northPanel;
  DecimalFormat df = new DecimalFormat("#,###,##0.00");
  String mess1 = "Enter data and hit return";
  String mess2 = "Enter numbers as XXXX.XX";

  public BankGui (String s) {
    super(s);
  }

  public void init () {

    setLayout (new BorderLayout() );

    // north panel = input fields and labels

    northPanel = new Panel();
    northPanel.setLayout (new GridLayout(3,2) );

    investLabel = new Label("investment in S   ", Label.RIGHT);
    northPanel.add(investLabel);
    investField = new TextField("",12);
    investField.addActionListener(this);
    northPanel.add(investField);

    rateLabel = new Label("interest rate in %   ", Label.RIGHT);
    northPanel.add(rateLabel);
    rateField = new TextField("",4);
    rateField.addActionListener(this);
    northPanel.add(rateField);

    errorLabel = new Label("                     ", Label.RIGHT);
    errorLabel.setForeground(Color.red);
    northPanel.add(errorLabel);
    messLabel = new Label(mess1, Label.LEFT);
    northPanel.add(messLabel);

    add (northPanel, "North");

    // east = table canvas

    tableCanvas = new TableCanvas(); // defined below
    add (tableCanvas, "East");

    // center = diagram canvas

    diagramCanvas = new DiagramCanvas(); // defined below
    add (diagramCanvas, "Center");

    addWindowListener(this);
    pack(); 
    setVisible(true);
  }

  public static void main (String[] args) {
    BankGui f = new BankGui("BankGui");
    f.init();
  }

  private class TableCanvas extends Canvas { // inner class

    public Dimension getMinimumSize() {
      return new Dimension(200,300);
    }
    public Dimension getPreferredSize() {
      return getMinimumSize();
    }

    public void paint (Graphics g) {
     try {
      Dimension mySize = getSize();
      int width = mySize.width;
      int height = mySize.height;
      int x1 = 10;
      int x2 = width / 3;
      int x3 = width - 10;
      int y1 = 10;
      int dy = (height - 20) / 13;
      int y;

      g.setColor (Color.black);

      y = y1 + dy;  
      g.drawString ("year", x1, y);
      g.drawString ("amount", x2, y);

      y = y + 8;
      g.drawLine (x1,y, x3,y);
 
      for (int year=0; year<amount.length; year++) {
        y = y + dy;
        g.drawString (""+year, x1, y);
        g.drawString (df.format(amount[year]), x2, y);
      }
     } catch (Exception e) {
         System.out.println(e);
     }
    }
  } // end of inner class TableCanvas

  private class DiagramCanvas extends Canvas { // inner class

    public Dimension getMinimumSize() {
      return new Dimension(120,220);
    }
    public Dimension getPreferredSize() {
      return getMinimumSize();
    }

    public void paint (Graphics g) {
     try {
      Dimension mySize = getSize();
      int width = mySize.width;
      int height = mySize.height;
      int x1 = 10;
      int x2 = width - 10;
      int dx = (width - 20) / (amount.length - 1) ;
      int y1 = 10;
      int y2 = height - 10;
      double scale = (2.0 * invest) / (double)(y2-y1);
      int[] x = new int [amount.length];
      int[] y = new int [amount.length];

      g.setColor (Color.white);
      g.fillRect (0,0, width,height);

      g.setColor (Color.black);
      g.drawRect (x1,y1, dx*(amount.length-1), y2-y1);
   
       for (int year=0; year<amount.length; year++) {
        x[year] = x1 + year * dx;
        y[year] = y2 - (int)( amount[year]/scale );
      }
      g.setColor (Color.blue);
      g.drawPolyline (x,y, amount.length);
      for (int i=0; i<amount.length; i++) {
        g.drawLine (x[i],y2, x[i],y[i]);
      }
     } catch (Exception e) {
         System.out.println(e);
     }
    }
  } // end of inner class DiagramCanvas

  public void actionPerformed (ActionEvent e) {
    try {    
      invest = Double.valueOf 
        ( investField.getText().trim() ).doubleValue();
      rate = Double.valueOf
        ( rateField.getText().trim() ).doubleValue();
      factor = (100.0 + rate) / 100.0;

      // Model:
      amount[0]=invest;
      for (int year=1; year<amount.length; year++) {
        amount[year] = amount[year-1] * factor;
      }
 
      // View:
      errorLabel.setText(" ");
      messLabel.setText(mess1);
      tableCanvas.repaint();
      diagramCanvas.repaint();

    } catch (Exception ex) {
        errorLabel.setText("*** Error: ");
        messLabel.setText(mess2);
    }
  }
  public void windowClosing (WindowEvent e) {
    System.exit(0);
  }
  public void windowClosed (WindowEvent e) { }
  public void windowOpened (WindowEvent e) { }
  public void windowIconified (WindowEvent e) { }
  public void windowDeiconified (WindowEvent e) { }
  public void windowActivated (WindowEvent e) { }
  public void windowDeactivated (WindowEvent e) { }
}
