public class BankModel {

  private double invest, rate, factor;
  private int numYears=10;
  private double[] amount = new double[numYears+1];

  public void setInvest (double invest) {
    this.invest = invest;
    calculateAmount();
  }

  public double getInvest () {
    return invest;
  }

  public void setRate (double rate) {
    this.rate = rate;
    calculateAmount();
  }

  public double getRate () {
    return rate;
  }

  private void calculateAmount() {
    factor = (100.0 + rate) / 100.0;
    amount[0]=invest;
    for (int year=1; year<amount.length; year++) {
      amount[year] = amount[year-1] * factor;
    }
  }

  public double[] getAmount () {
    return amount;
  }
}
