import java.awt.*;
import java.awt.event.*;
import java.text.*;

public class BankTable extends Canvas {

  private BankModel bankModel;
  private double[] amount;
  private DecimalFormat df = 
    new DecimalFormat("#,###,##0.00");

  public BankTable (BankModel bm) {
    this.bankModel = bm;
  }

  public Dimension getMinimumSize() {
    return new Dimension(200,300);
  }
  public Dimension getPreferredSize() {
    return getMinimumSize();
  }

  public void paint (Graphics g) {

    amount = bankModel.getAmount();

    Dimension mySize = getSize();
    int width = mySize.width;
    int height = mySize.height;
    int x1 = 10;
    int x2 = width / 3;
    int x3 = width - 10;
    int y1 = 10;
    int dy = (height - 20) / 13;
    int y;

    g.setColor (Color.black);

    y = y1 + dy;  
    g.drawString ("year", x1, y);
    g.drawString ("amount", x2, y);

    y = y + 8;
    g.drawLine (x1,y, x3,y);
 
    try {
      for (int year=0; year<amount.length; year++) {
        y = y + dy;
        g.drawString (""+year, x1, y);
        g.drawString (df.format(amount[year]), x2, y);
      }
    } catch (Exception e) {
        System.out.println(e);
    }
  }
} 
