import java.awt.* ;
import java.awt.event.*;
import java.applet.* ;

public class BlinkLight extends Applet
  implements Runnable {

  private boolean runFlag;
  private Image img;
  private Graphics g;
  private Thread t = null;
  private int width, height, diameter, x1, y1;

  public void init() {

    Dimension d = getSize();
    img = createImage(d.width, d.height);
    g=img.getGraphics();
    width = d.width;
    height = d.height;
    if (width < height) {
      diameter = 2 * width / 3;
    }
    else {
      diameter = 2 * height / 3;
    }
    x1 = (width - diameter) / 2;
    y1 = (height - diameter) / 2;
  }

  public void start() {
    if (t == null) {
      t = new Thread (this);
      t.start();
    }
  }
  public void stop() {
    if (t != null) {
      runFlag = false; // t.stop();
      t=null;
    }
  }

  public void run () {
    boolean onOff = false;
    runFlag = true;
    // costant background of image
    g.setColor (Color.black);
    g.fillRect (0, 0, width, height);

    while (runFlag) {

      // prepare image
      if (onOff) {
        g.setColor (Color.yellow);
      }
      else { // also needed to bypass an error of some 1.1.x compiler optimizations
        g.setColor (Color.black);
      }
      g.fillOval (x1, y1, diameter, diameter);
      // paint the new image (without flicker)
      repaint();

      onOff = ! onOff;
      // wait 1 second
      try { Thread.sleep(1000); }
      catch (InterruptedException e) {}
    }
  }

  public void update (Graphics g) {
    paint(g); // no clear necessary
  }

  public void paint (Graphics g) {
    if (img != null)
      g.drawImage(img,0,0,null);
  }

}
