import java.util.*;
import java.text.*;

public class Date11 {  // Date Version 1.1
  public static void main (String[] args) {

    DateFormat df = new SimpleDateFormat ("d. MMMM yyyy", 
      Locale.GERMANY);
    DateFormat tf = new SimpleDateFormat ("HH.mm", 
      Locale.GERMANY);

    SimpleTimeZone mez = new SimpleTimeZone( +1*60*60*100, "MEZ");
    mez.setStartRule (Calendar.MARCH, -1, Calendar.SUNDAY, 
      2*60*60*1000);
    mez.setEndRule (Calendar.OCTOBER, -1, Calendar.SUNDAY, 
      2*60*60*1000);

    Calendar cal = GregorianCalendar.getInstance (mez);
    cal.setLenient(false); // do not allow bad values

    Date today = new Date();
    System.out.println ("Heute ist der " + df.format(today) );
    System.out.println ("Es ist " + tf.format(today) + " Uhr");

    cal.setTime(today);
    int currentYear = cal.get(Calendar.YEAR);
    System.out.println ("Wir haben das Jahr " + currentYear );

    cal.add (Calendar.DATE, -1);
    Date yesterday = cal.getTime();
    System.out.println ("Gestern war der " + df.format(yesterday) );

    try {
      cal.set (97, Calendar.MAY, 35);
      cal.setTime(cal.getTime()); // to avoid a bug
      Date bad = cal.getTime();
      System.out.println ("Bad date 35.Mai was set to " + 
        df.format(bad) );
    } catch (Exception e) {
      System.out.println ("Bad date 35.Mai gives " + e);
    }

    cal.set (1996, Calendar.FEBRUARY, 29, 0, 0, 0);
    cal.setTime(cal.getTime()); // to avoid a bug
    Date marriage = cal.getTime();
    System.out.println ("geheiratet am " + df.format(marriage) );

    long todayInt = today.getTime();
    long marriageInt = marriage.getTime();
    long diff = todayInt - marriageInt;
    System.out.println ("seit " + 
        diff/(24*60*60*1000) + " Tagen verheiratet" );
    int marriageYear = cal.get(Calendar.YEAR);
    System.out.println ("seit " + 
        (currentYear-marriageYear) + " Jahren verheiratet" );

    cal.setTime(marriage);
    /* bypass leap year error in add YEAR method: */
    if ( (cal.get(Calendar.MONTH) == Calendar.FEBRUARY) &&
         (cal.get(Calendar.DATE) == 29) ) {
      cal.add (Calendar.DATE, 1);
    }
    /* end of leap year error bypass */
    cal.add (Calendar.YEAR, 25); 
    Date silverMarriage = cal.getTime();
    System.out.println ("Silberne Hochzeit am " +
      df.format(silverMarriage) );

    String todayDay = df.format(today);
    String silverDay = df.format(silverMarriage);
    // compare only day, not time:
    if ( silverDay.equals(todayDay) )
      System.out.println ("Herzlichen Glueckwunsch!");
      
  }
}
