import java.awt.*;
import java.awt.event.*;

class GarMapController implements MouseListener {

  private static final boolean TEST = false;

  private Garden garden;

  protected GarMapController (Garden g) {
    this.garden = g;
  }

  public void mouseClicked (MouseEvent e) {
    // will also trigger mouseReleased, see there
  }
  public void mouseEntered (MouseEvent e) {
  }
  public void mouseExited (MouseEvent e) {
  }
  public void mousePressed (MouseEvent e) {
  }
  public void mouseReleased (MouseEvent e) {
    // also happens at mouseClicked and mouseDragged 

    if (TEST) {
      System.out.println("Mouse clicked  x=" + e.getX() + "  y=" + e.getY() );
    }

    if (garden.newTree == null) {
	garden.newTree = 
	  new Tree (e.getX(), e.getY(), garden.planted );
    }
    else {
      garden.newTree.setLocation( e.getX(), e.getY() );
    }
    
    if (garden.newTree.isGood) {
      garden.mess.mess1="Click 'okay' to plant the tree here, ";
      garden.mess.mess2="or click to another location. ";
    }
    else {
      if ( garden.newTree.outOfGarden ) {
        garden.mess.mess1="No, not outside the garden. ";
      }
      else
      if ( garden.newTree.inHouse ) {
        garden.mess.mess1="No, not in the house. ";
      }
      else
      if ( garden.newTree.tooNear ) {
        garden.mess.mess1="No, not enough space here. ";
      }
      garden.mess.mess2="Please, click to a better location. ";
    }
    if ( garden.planted.isFull ) {
      garden.mess.mess1="We already have enough trees, thank you. ";
      garden.mess.mess2="Please, click 'empty' if you want to re-start. ";
      garden.newTree.isGood=false;
    }
    garden.map.repaint();
    garden.mess.repaint();
    garden.okButton.setEnabled( garden.newTree.isGood );
  }
}
