import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

public class Garden extends Applet {

  protected Planted planted;
  protected Tree newTree = null;
  private GardenController controller;
  private GarMapController mapController;

  protected Label titleLabel;
  protected GardenMap map;     // extends Canvas
  protected GardenPic picture; // extends Canvas
  protected GardenMess mess;   // extends Canvas
  protected Button okButton, undoButton, emptyButton;
  private Panel northPanel, eastPanel, westPanel, centerPanel, southPanel,
        buttonPanel;

  public void init () {
    controller = new GardenController (this);
    mapController = new GarMapController (this);
    planted = new Planted (12);
    newTree = null;

    setLayout ( new BorderLayout() );

    // north panel = title label

    northPanel = new Panel();
    northPanel.setLayout (new FlowLayout() );
    titleLabel = new Label ("Plant Trees in a Garden ");
    northPanel.add(titleLabel);
    add (northPanel, "North");

    // west panel = garden map

    map = new GardenMap (this);
    map.addMouseListener (mapController);
    add (map, "West");

    // east panel = garden picture

    picture = new GardenPic (this);
    add (picture, "East");

    // south panel = messages text panel plus three buttons

    mess = new GardenMess(); 
    controller.initMess();

    okButton = new Button("Okay ");
    okButton.addActionListener (controller);
    okButton.setActionCommand ("ok");
    okButton.setEnabled(false);

    undoButton = new Button("Undo ");
    undoButton.addActionListener (controller);
    undoButton.setActionCommand ("undo");

    emptyButton = new Button("Empty ");
    emptyButton.addActionListener (controller);
    emptyButton.setActionCommand ("empty");

    buttonPanel = new Panel();
    buttonPanel.setLayout (new FlowLayout() );
    buttonPanel.add(okButton);
    buttonPanel.add(undoButton);
    buttonPanel.add(emptyButton);

    southPanel = new Panel();
    southPanel.setLayout (new BorderLayout() );
    southPanel.add(mess, "Center");
    southPanel.add(buttonPanel, "South");
    add (southPanel, "South");

    setVisible(true);
    map.setVisible(true); // enables MouseListener
    // picture.setVisible(true);
    // mess.setVisible(true);
  }
}
