import java.awt.*;
import java.awt.event.*;

class GardenController implements ActionListener {

  private static final boolean TEST = false;

  private Garden garden;

  protected GardenController (Garden g) {
    this.garden = g;
  }

  protected void initMess() {
    garden.mess.mess1="In order to plant a tree in the garden, ";
    garden.mess.mess2="please click to the location on the map. ";
  }

  public void actionPerformed (ActionEvent e) {

    String which = (String) e.getActionCommand();
    if (TEST) {
      System.out.println("Button ." + which + ". pressed");
    }

    if ( which.equals("ok") && 
	 garden.newTree != null &&
	 garden.newTree.isGood ) {
      garden.planted.addTree (garden.newTree);
      garden.newTree = null;
      garden.mess.mess1="To plant another tree in the garden, ";
      garden.mess.mess2="click to the location on the map. ";
      if (garden.planted.isFull) {
        garden.mess.mess1="Thank you for planting so many trees! ";
        garden.mess.mess2="Click 'empty' to re-start, or exit the web page. ";
      }
      garden.map.repaint();
      garden.picture.repaint();
      garden.mess.repaint();
    }

    if ( which.equals("undo") ) {
      if ( garden.newTree != null ) {
        garden.newTree = null;
      }
      else {
	garden.planted.removeLastTree();
      }
      garden.mess.mess1="In order to plant another tree in the garden, ";
      garden.mess.mess2="click to the location on the map. ";
      garden.map.repaint();
      garden.picture.repaint();
      garden.mess.repaint();
    }

    if ( which.equals("empty") ) {
      garden.planted.removeAllTrees();
      garden.newTree = null;
      initMess();
      garden.map.repaint();
      garden.picture.repaint();
      garden.mess.repaint();
    }

    garden.okButton.setEnabled(false);
  }
}
