import java.awt.*;
import java.awt.event.*;

class GardenMap extends Canvas {

  private Garden garden;

  protected GardenMap (Garden g) {
    this.garden = g;
  }

  public Dimension getMinimumSize() {
    return new Dimension(200,200);
  }
  public Dimension getPreferredSize() {
    return getMinimumSize();
  }

  public void paint (Graphics g) {
    g.setColor (Color.white);
    g.fillRect (0, 0, 200, 200);
    // draw map of garden and house
    g.setColor (Color.black);
    // garden
    g.drawLine (10, 10, 190, 10);
    g.drawLine (10, 10, 10, 190);
    g.drawLine (190, 190, 190, 10);
    g.drawLine (190, 190, 10, 190);
    // house walls
    g.drawLine (30, 10, 30, 90);
    g.drawLine (170, 10, 170, 90);
    g.drawLine (30, 90, 170, 90);
    // house roof
    g.drawLine (30, 10, 70, 50);
    g.drawLine (30, 90, 70, 50);
    g.drawLine (70, 50, 130, 50);
    g.drawLine (130, 50, 170, 10);
    g.drawLine (130, 50, 170, 90);
    // draw outlines of planted trees
    for (int i=0; i<garden.planted.numTrees; i++) {
      if (garden.planted.tree[i] != null) {
        g.drawOval ( garden.planted.tree[i].x -20, 
		     garden.planted.tree[i].y -20, 40, 40);
      }
    }
    // draw new tree in green (okay) or red 
    if (garden.newTree != null) {
      if (garden.newTree.isGood) {
	g.setColor (Color.green);
      }
      else {
	g.setColor (Color.red);
      }
      g.fillOval ( garden.newTree.x -20, 
		   garden.newTree.y -20, 40, 40);
    }
  }
}
