import java.awt.*;
import java.awt.event.*;

class GardenPic extends Canvas {
  private Garden garden;

  protected GardenPic (Garden g) {
    this.garden = g;
  }

  public Dimension getMinimumSize() {
    return new Dimension(200,200);
  }
  public Dimension getPreferredSize() {
    return getMinimumSize();
  }

  public void paint (Graphics g) {
    g.setColor (Color.white);
    g.fillRect (0, 0, 200, 200);
    // draw garden
    g.setColor (Color.green);
    g.fillRect (0, 181, 200, 9);
    g.setColor (Color.black);
    g.drawLine (0, 181, 200, 181);
    g.drawLine (10, 181, 10, 160);
    g.drawLine (190, 181, 190, 160);
    // draw house in the background
    int xx[]= {26,70,130,174};
    int yy[]= {140,110,110,140};
    g.setColor (Color.yellow);
    g.fillRect (30, 140, 140, 40);
    g.setColor (Color.red);
    g.fillPolygon (xx, yy, 4);
    g.setColor (Color.black);
    g.fillRect (45, 150, 10, 15);
    g.fillRect (65, 150, 10, 15);
    g.fillRect (91, 150, 18, 30);
    g.fillRect (125, 150, 10, 15);
    g.fillRect (145, 150, 10, 15);
    g.drawRect (30, 140, 140, 40);
    g.drawPolygon  (xx, yy, 4);
    // draw trees in the foreground
    g.setColor (Color.green);
    for (int i=0; i<garden.planted.numTrees; i++) {
      if (garden.planted.tree[i] != null) {
        g.fillRect ( garden.planted.tree[i].x -1,  140,  3, 42);
        g.fillOval ( garden.planted.tree[i].x -20, 120, 40, 40);
      }
    }
  }
}
