import java.awt.*;
import java.awt.event.*;

public class Gui extends Frame
  implements ActionListener, WindowListener {

  private Label titleLabel;
  private Button openButton, closeButton;
  private Panel northPanel, southPanel;

  public Gui (String s) {
    super(s);
  }

  public void init () {

    setLayout (new BorderLayout() );

    // north panel = title label

    northPanel = new Panel();
    northPanel.setLayout (new FlowLayout() );
    titleLabel = new Label ("GUI Exercise ");
    northPanel.add(titleLabel);
    add (northPanel, "North");

    // south panel = two buttons

    openButton = new Button(" Open ");

    closeButton = new Button(" Close ");
    closeButton.addActionListener (this);
    closeButton.setActionCommand ("close");

    southPanel = new Panel();
    southPanel.setLayout (new FlowLayout() );
    southPanel.add(openButton);
    southPanel.add(closeButton);
    add (southPanel, "South");

    addWindowListener(this);
    pack(); // setSize(500,500);
    setVisible(true);
  }

  public static void main (String[] args) {
    Gui f = new Gui("Test");
    f.init();
  }

  public void actionPerformed (ActionEvent e) {
    String which = e.getActionCommand();
    if ( which.equals("close") ) {
      dispose();
      System.exit(0);
    }
  }
  public void windowClosing (WindowEvent e) {
    dispose();
    System.exit(0);
  }
  public void windowClosed (WindowEvent e) { }
  public void windowOpened (WindowEvent e) { }
  public void windowIconified (WindowEvent e) { }
  public void windowDeiconified (WindowEvent e) { }
  public void windowActivated (WindowEvent e) { }
  public void windowDeactivated (WindowEvent e) { }
}
