public class Konto {

   private Person inhaber;
   private double guthaben = 0.0;

   public Konto (Person inhaber) {
      this.setInhaber(inhaber);
   }

   private void setInhaber (Person inhaber) {
      this.inhaber = inhaber;
   }
   public Person getInhaber() {
      return this.inhaber;
   }

   private void setGuthaben (double neuerBetrag) {
      this.guthaben = neuerBetrag;
   }
   public double getGuthaben() {
      return this.guthaben;
   }

   public void einzahlen (double betrag) {
      this.setGuthaben( this.guthaben + betrag );
   }

   public void abheben (double betrag)
         throws KontoNichtGedecktException {
      double neuerBetrag = this.guthaben - betrag;
      if ( neuerBetrag < 0.0 ) {
         throw new KontoNichtGedecktException();
      }
      this.setGuthaben( this.guthaben - betrag );
   }

   public String toString() {
      return this.inhaber + ": " + this.guthaben + " Euro";
   }

   public static void main (String[] args) {

     Person hubert = new Person ("Partl", "Hubert");
     Konto kontoH = new Konto (hubert);
     System.out.println(kontoH);
     kontoH.einzahlen(1000.0);
     System.out.println(kontoH);
     try {
     kontoH.abheben(500.0);
     } catch (KontoNichtGedecktException e) {
          System.out.println("*** Konto nicht gedeckt");
     }
     System.out.println(kontoH);
     try {
     kontoH.abheben(9999.0);
     } catch (KontoNichtGedecktException e) {
          System.out.println("*** Konto nicht gedeckt");
     }
     System.out.println(kontoH);


     Student anna = new Student ("Fleissig", "Anna", "Uni Wien");
     Konto kontoA = new Konto (anna);
     System.out.println(kontoA);
     kontoA.einzahlen(1000.0);
     System.out.println(kontoA);
     try {
     kontoA.abheben(500.0);
     } catch (KontoNichtGedecktException e) {
          System.out.println("*** Konto nicht gedeckt");
     }
     System.out.println(kontoA);

   }
}
