public class Kurs {
  private String kursTitel = null;
  private boolean kostenlos = false;
  private int anzahl = 0;
  private String[] teilnehmer;

  public Kurs (String kursTitel, int maxAnzahl) {
    setKursTitel(kursTitel);
    teilnehmer = new String [maxAnzahl];
  }

  private void setKursTitel (String kursTitel) {
    this.kursTitel = kursTitel;
  }
  public String getKursTitel() {
    return kursTitel;
  }
  public void setKostenlos (boolean kostenlos) {
    this.kostenlos = kostenlos;
  }
  public boolean isKostenlos() {
    return kostenlos;
  }
  // no setTeilnehmer(String[])
  public String[] getTeilnehmer() {
    return teilnehmer;
  }
  private void setTeilnehmer (int i, String name)
      throws ArrayIndexOutOfBoundsException {
    this.teilnehmer[i] = name;
  }
  public String getTeilnehmer (int i)
      throws ArrayIndexOutOfBoundsException {
    return teilnehmer[i];
  }
  public void addTeilnehmer (String name)
      throws ArrayIndexOutOfBoundsException {
    if (anzahl >= teilnehmer.length )
      throw new ArrayIndexOutOfBoundsException();
    else {
      anzahl++;
      setTeilnehmer (anzahl-1, name);
    }
  }
  // no setAnzahl(int)
  public int getAnzahl() {
    return anzahl;
  }
  public int getMaxAnzahl() {
    return teilnehmer.length;
  }
  public boolean equals (Object other) {
   return ( other instanceof Kurs &&
     ((Kurs)other).kursTitel.equals (this.kursTitel) );
  }
  public String toString() {
    String s = getKursTitel();
    if ( isKostenlos() )
      s = s + " (kostenlos)";
    s = s + ": " + getAnzahl() + " Teilnehmer, "
      + (getMaxAnzahl()-getAnzahl()) + " Pltze frei";
    return s;
  }

  public static void main (String[] args) {
    Kurs java1 = new Kurs ("Java Einfuehrung", 15);
    java1.setKostenlos(true);
    Kurs java2 = new Kurs ("Java fuer Fortgeschrittene", 8);
    java1.addTeilnehmer("Hubert");
    java2.addTeilnehmer("Hubert");
    java1.addTeilnehmer("Clemens");
    java1.addTeilnehmer("Ernst");
    java2.addTeilnehmer("Markus");
    System.out.println (java1);
    for (int i=0; i < java1.getAnzahl(); i++)
      System.out.println ("  " + java1.getTeilnehmer(i));
    System.out.println (java2);
    for (int i=0; i < java2.getAnzahl(); i++)
      System.out.println ("  " + java2.getTeilnehmer(i));
  }
}
