import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class MouseTest extends Applet 
  implements MouseListener, MouseMotionListener {

  private int mouseX, mouseY;
  private int radius, diameter = 20;
  private Color circleColor = Color.red;

  public void init() {
    Dimension full = getSize();
    mouseX = full.width/2;
    mouseY = full.height/2;
    radius=diameter/2;
    addMouseListener(this);
    addMouseMotionListener(this);
  }

  public void paint (Graphics g) {
    g.setColor (circleColor);
    g.fillOval ((mouseX-radius), (mouseY-radius), 
       diameter, diameter);
  }

  public void mousePressed (MouseEvent e) {
    mouseX = e.getX();
    mouseY = e.getY();
    circleColor = Color.green;
    repaint();
  }
  public void mouseReleased (MouseEvent e) {
    mouseX = e.getX();
    mouseY = e.getY();
    circleColor = Color.red;
    repaint();
  }
  public void mouseClicked (MouseEvent e) { }
  public void mouseEntered (MouseEvent e) { }
  public void mouseExited (MouseEvent e) { }

  public void mouseDragged (MouseEvent e) {
    mouseX = e.getX();
    mouseY = e.getY();
    circleColor = Color.green;
    repaint();
  }
  public void mouseMoved (MouseEvent e) { }

}


