import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Vector;

public class PersJList extends JFrame
    implements ActionListener {

  private Container c;
  private JLabel firstnameLabel, lastnameLabel;
  private JTextField firstnameField, lastnameField;
  private JButton addButton, removeButton;
  private JPanel northPanel;
  private JScrollPane scrollingList;

  private JList list;
  private DefaultListModel persons;

  public void init () {

    c = this.getContentPane();
    c.setLayout (new BorderLayout() );

     // north panel = fields and buttons

    firstnameLabel = new JLabel("first name ", JLabel.RIGHT);
    firstnameField = new JTextField(20);
    lastnameLabel = new JLabel("last name ", JLabel.RIGHT);
    lastnameField = new JTextField(20);
    removeButton = new JButton("remove");
    removeButton.addActionListener ( this );
    addButton = new JButton("add");
    addButton.addActionListener ( this );

    northPanel = new JPanel();
    northPanel.setLayout (new GridLayout(3,2) );
    northPanel.add(firstnameLabel);
    northPanel.add(firstnameField);
    northPanel.add(lastnameLabel);
    northPanel.add(lastnameField);
    northPanel.add(removeButton);
    northPanel.add(addButton);
    c.add (northPanel, "North");

    // center scroll pane = list of persons

    persons = new DefaultListModel();
    list = new JList( persons );
    JScrollPane scrollingList = new JScrollPane(list);
    c.add (scrollingList, "Center");

    setSize(250,200);
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setVisible(true);
  }

  public void actionPerformed (ActionEvent e) {
    String which = e.getActionCommand();
    if ( which.equals("add") ) {
      addPerson();
    }
    else
    if ( which.equals("remove") ) {
      removePerson();
    }
  }

  public void addPerson () {
    String firstname = firstnameField.getText().trim();
    String lastname = lastnameField.getText().trim();
    Person p = new Person (lastname, firstname);
    persons.addElement(p);
  }

  public void removePerson () {
    int i = list.getSelectedIndex();
    if ( i >= 0) {
      persons.removeElementAt(i);
    }
  }

  public static void main (String[] args) {
    PersJList f = new PersJList();
    f.init();
  }
}
