class Planted {

  private static final boolean TEST = false;

  protected int numTrees = 0;
  protected int maxTrees;
  protected Tree[] tree;
  protected boolean isFull;

  protected Planted (int maxTrees) {
    this.maxTrees = maxTrees;
    tree = new Tree [maxTrees];
    for (int i=0; i<tree.length; i++) {
      tree[i] = null;
    numTrees = 0;
    isFull = (numTrees >= maxTrees); /* false for maxTrees>0 */
    }
  }

  protected void addTree (Tree newTree) {
    if (! isFull) {
      numTrees++;
      tree [numTrees-1] = newTree;
    }
    isFull = (numTrees >= maxTrees);
    if (TEST) {
      System.out.println("Tree added, numTrees=" + numTrees);
    }
  }

  protected void removeLastTree () {
    if (numTrees > 0) {
      tree [numTrees-1] = null;
      numTrees--;
    }
    isFull = (numTrees >= maxTrees);
    if (TEST) {
      System.out.println("Tree removed, numTrees=" + numTrees);
    }
  }

  protected void removeAllTrees () {
    for (int i=0; i<numTrees; i++) {
      tree [i] = null;
    }
    numTrees = 0;
    isFull = (numTrees >= maxTrees);
    if (TEST) {
      System.out.println("All trees removed, numTrees=" + numTrees);
    }
  }
}
