import java.io.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

public class ShowDom {

  private String indentation = ". ";
  private Document doc;
  private Element root;

  public void doit(String filename) {
    try {
      File file = new File(filename);
      DocumentBuilderFactory factory =
        DocumentBuilderFactory.newInstance();
      DocumentBuilder builder =
        factory.newDocumentBuilder();
      doc = builder.parse( file );
      root = doc.getDocumentElement();
      showElements(root, 1);
    } catch (Exception e) {
        System.out.println(e);
    }
  }

  public void showElements(Node node, int level) {
    // called recursively, starting with root
    if (node instanceof Text) {
      String s = node.getNodeValue().trim();
      if (s.length()>0) {
        for (int i=1; i<=level; i++) {
          System.out.print(indentation);
        }
        System.out.println("= " + s);
      }
    } else {
      for (int i=1; i<=level; i++) {
        System.out.print(indentation);
      }
      System.out.println(node.getNodeName());
    }
    NodeList children = node.getChildNodes();
    for (int i=0; i<children.getLength(); i++) {
      showElements( children.item(i), level+1 );
      // recursive call for next level
    }
  }

  public static void main (String[] args) {
      ShowDom prog = new ShowDom();
      prog.doit("mitarbeiter.xml");
  }

}
