import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import javax.xml.parsers.*;

public class ShowSax extends DefaultHandler {

  private int level = 0;
  private String indentation = ". ";

  public void doit(String filename) {
    try {
      File file = new File(filename);
      SAXParserFactory factory =
        SAXParserFactory.newInstance();
      SAXParser parser = factory.newSAXParser();
      parser.parse( file, this );
    } catch (Exception e) {
        System.out.println(e);
    }
  }

  public void startElement
      (String namespaceURI, String sname, String qname,
       Attributes attrs) {
    level = level + 1;
    for (int i=1; i<=level; i++) {
      System.out.print(indentation);
    }
    System.out.println(qname);
  }

  public void endElement
      (String namespaceURI, String sname, String qname) {
    level = level - 1;
  }

  public void characters
      (char[] ch, int start, int length) {
    String s = new String (ch, start, length).trim();
    if (s.length()>0) {
      for (int i=1; i<=level; i++) {
        System.out.print(indentation);
      }
      System.out.println("= " + s);
    }
  }

  public static void main (String[] args) {
      ShowSax prog = new ShowSax();
      prog.doit("mitarbeiter.xml");
  }

}
