import java.awt.* ;
import java.applet.* ;

public class Strampeln extends Applet
  implements Runnable {

  private volatile boolean runFlag;
  private int height=400, width=300;
  private Image i1, i2, i3;
  private volatile int i=0;
  private boolean started=false;
  private Graphics g;
  private Thread t = null;
  private MediaTracker mt = new MediaTracker(this);

  public void init() {
    started=false;
    // start image loading in separate Thread that will set started to true
    new Thread( new Runnable() { public void run() {
      i1 = getImage( getCodeBase(), "strampeln1.jpg");
      i2 = getImage( getCodeBase(), "strampeln2.jpg");
      i3 = getImage( getCodeBase(), "strampeln3.jpg");
      mt.addImage (i1, 1);
      mt.addImage (i2, 2);
      mt.addImage (i3, 3);
      try {
        mt.waitForAll();
        // System.out.println("Alle Bilder geladen.");
        started=true;
      } catch (InterruptedException e) {}
    }} ).start();
    // return immediately to display "Bitte warten" as long as started==false
  }

  public void start() {
    if (t == null)
      {
      t = new Thread (this);
      t.start();
      }
  }
  public void stop() {
    if (t != null)
      {
      runFlag=false; // or: t.stop();
      t=null;
      }
  }

  private void step (int bildNummer) {
      i=bildNummer;
      repaint();
      try { Thread.sleep(500); }
      catch (InterruptedException e) {}
  }

  public void run () {
    runFlag=true;
    // System.out.println("Thread gestartet.");
    while (runFlag) {
      step(1);
      step(2);
      step(3);
      step(2);
    }
  }

  public void update (Graphics g) {
    paint(g);
  }

  public void paint (Graphics g) {
    if (started)  {
      // System.out.println("Zeichen Bild " + i);
      switch(i) {
        case 1: if (i1!=null) g.drawImage(i1,0,0,this); break;
        case 2: if (i2!=null) g.drawImage(i2,0,0,this); break;
        case 3: if (i3!=null) g.drawImage(i3,0,0,this); break;
      }
    } else { // not started
        // System.out.println("Noch nicht gestartet.");
        g.drawString("Bitte warten ...", 100, 25);
    }
  }

}
