import java.awt.*;
import java.awt.event.*;
import java.sql.*;

public class SuchFrame extends Frame
      implements ActionListener, WindowListener {

  private String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
  private String database = "jdbc:odbc:TestDB1";

  private Label ueberschrift = new Label
    ("Teilstring-Suche in Vor- und Zunamen");
  private TextField eingabe = new TextField(20);
  private Button suchButton = new Button ("Suchen");
  private Label ergebnis = new Label
    ("0 Mitarbeiter gefunden");
  private TextArea ausgabe = new TextArea(8,40);
  private FlowLayout layout = new FlowLayout();

  public void init() {
    try {
      Class.forName( driver );
    } catch (Exception e) {
        ausgabe.setText("Fehler: " + e);
    }
    this.setTitle("Datenbank-Suche");
    this.setLayout(layout);
    this.setSize(360, 300);
    this.add(ueberschrift);
    this.add(eingabe);
    this.add(suchButton);
    this.add(ergebnis);
    this.add(ausgabe);
    eingabe.addActionListener(this);
    suchButton.addActionListener(this);
    this.addWindowListener(this);
  }

  public void actionPerformed (ActionEvent event) {
    // Enter im TextField oder Klick auf den Button
    String suchString = eingabe.getText().trim();
    suchen (suchString);
  }

  private void suchen (String x) {
    int count = 0; // bisher nichts gefunden
    ausgabe.setText(""); // alte Ausgabe lschen, Platz fr neue
    String sql =
      "SELECT Vorname, Zuname, Geburtsjahr FROM Mitarbeiter "
      + " WHERE Vorname LIKE '%" + x + "%' "
      + " OR Zuname LIKE '%" + x + "%' "
      + " ORDER BY Vorname, Zuname ";
    Connection con = null;
    Statement stmt = null;
    ResultSet rs = null;
    try {
      con = DriverManager.getConnection ( database );
      stmt = con.createStatement();
      rs = stmt.executeQuery ( sql );
      while (rs.next()) {
        String zeile =
           rs.getString(1) + " " + rs.getString(2)
           + ", geb. " + rs.getInt(3);
         ausgabe.append( zeile + "\n" );
         count = count + 1;
      }
    } catch (Exception e) {
        ausgabe.append( "Fehler: " + e + "\n");
    }
    ergebnis.setText( count + " Mitarbeiter gefunden");
    // alles schlieen, was eventuell geffnet wurde
    try {rs.close(); } catch (Exception ex) {}
    try {stmt.close(); } catch (Exception ex) {}
    try {con.close(); } catch (Exception ex) {}
  }

  public void windowClosing (WindowEvent e) {
    this.setVisible(false);
    System.exit(0);
  }

  public void windowClosed (WindowEvent e) { }
  public void windowOpened (WindowEvent e) { }
  public void windowIconified (WindowEvent e) { }
  public void windowDeiconified (WindowEvent e) { }
  public void windowActivated (WindowEvent e) { }
  public void windowDeactivated (WindowEvent e) { }

  public static void main (String[] args) {
    SuchFrame fenster = new SuchFrame();
    fenster.init();
    fenster.setVisible(true);

  }

}
