import java.awt.*;

public class TheLight extends Canvas {

  public static final int RED = 1;
  public static final int REDYELLOW = 2;
  public static final int GREEN = 3;
  public static final int YELLOW = 4;
  private static final int MAXSTATE = 4;
  
  private int lightState = RED;

  public int getState() {
     return lightState;
  }
  public void setState (int state) {
    lightState=state;
  }
  public void nextState() {
    lightState++;
    if (lightState>MAXSTATE) {
      lightState=1;
    }
  }

  public Dimension getMinimumSize() {
    return new Dimension(100,260);
  }
  public Dimension getPreferredSize() {
    return getMinimumSize();
  }

  public void paint (Graphics g) {
    switch (lightState) {
      case RED: 
        paintLights (g, true, false, false); 
        break;
      case REDYELLOW: 
        paintLights (g, true, true, false); 
        break;
      case GREEN: 
        paintLights (g, false, false, true); 
        break;
      case YELLOW: 
        paintLights (g, false, true, false); 
        break;
      }
    }

  private void paintLights (Graphics g, 
      boolean red, boolean yellow, boolean green) {
    g.setColor (Color.black);
    g.fillRect (10, 10, 80, 240);
    if (red) {
      g.setColor (Color.red);
      g.fillOval (20, 20, 60, 60);
    }
    if (yellow) {
      g.setColor (Color.yellow);
      g.fillOval (20, 100, 60, 60);
    }
    if (green) {
      g.setColor (Color.green);
      g.fillOval (20, 180, 60, 60);
    }
  }
}
