import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class ThermoApplet
  extends Applet implements ActionListener {

  private ThermoModel model;
  private Label tempDisplay;
  private Button plusButton, minusButton;

  public void init () {

    model = new ThermoModel();
    model.setTemp(21);

    tempDisplay = new Label("00", Label.CENTER);
    Font bigFont = new Font ("Helvetica", Font.BOLD, 40);
    tempDisplay.setFont(bigFont);
    tempDisplay.setText( ""+model.getTemp() );

    minusButton = new Button("-1");
    minusButton.addActionListener ( this );

    plusButton = new Button("+1");
    plusButton.addActionListener ( this );

    setLayout (new FlowLayout() );
    add(minusButton);
    add(tempDisplay);
    add(plusButton);

    setVisible(true);
  }

  public void actionPerformed (ActionEvent e) {
    String which = e.getActionCommand();
    if ( which.equals("-1") ) {
      model.addTemp(-1);
    }
    else if ( which.equals("+1") ) {
      model.addTemp(+1);
    }
    tempDisplay.setText( ""+model.getTemp() );
  }
}
