import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ThermoJFrame extends JFrame
    implements ActionListener {

  private ThermoModel model;
  private Container c;
  private JLabel tempDisplay;
  private JButton plusButton, minusButton;
  private JPanel centerPanel, southPanel;

  public void init () {

    model = new ThermoModel();
    model.setTemp(22);

    c = this.getContentPane();
    c.setLayout (new BorderLayout() );

    // center panel = temperature display

    tempDisplay = new JLabel("00", JLabel.CENTER);
    Font bigFont = new Font ("Helvetica", Font.BOLD, 20);
    tempDisplay.setFont(bigFont);
    showTemp();

    centerPanel = new JPanel();
    centerPanel.setLayout (new FlowLayout() );
    centerPanel.add(tempDisplay);
    c.add (centerPanel, "Center");

     // south panel = two buttons

    minusButton = new JButton(" -1");
    minusButton.addActionListener ( this );
    minusButton.setActionCommand ("minus");

    plusButton = new JButton("+1");
    plusButton.addActionListener ( this );
    plusButton.setActionCommand ("plus");

    southPanel = new JPanel();
    southPanel.setLayout (new FlowLayout() );
    southPanel.add(minusButton);
    southPanel.add(plusButton);
    c.add (southPanel, "South");

    setSize(200,100);
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setVisible(true);
  }

  protected void showTemp() {
    int temp = model.getTemp();
    tempDisplay.setBackground(Color.white);
    if (temp<20) {
      tempDisplay.setForeground(Color.blue);
    }
    else if (temp>25) {
      tempDisplay.setForeground(Color.red);
    }
    else {
      tempDisplay.setForeground(Color.black);
    }
    tempDisplay.setText("" + temp);
  }

  public void actionPerformed (ActionEvent e) {
    String which = e.getActionCommand();
    if ( which.equals("minus") ) {
      model.addTemp(-1);
    }
    else if ( which.equals("plus") ) {
      model.addTemp(+1);
    }
    showTemp();
  }

  public static void main (String[] args) {
    ThermoJFrame f = new ThermoJFrame();
    f.init();
  }
}
