import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class ThermoView extends Applet {

  private ThermoModel model;
  private ThermoController controller;
  private Label tempDisplay;
  private Button plusButton, minusButton;
  private Panel centerPanel, southPanel;

  public void init () {

    model = new ThermoModel();
    model.setTemp(22);
    controller = new ThermoController (this, model);

    setLayout (new BorderLayout() );

    // center panel = temperature display

    tempDisplay = new Label("00", Label.CENTER);
    Font bigFont = new Font ("Helvetica", Font.BOLD, 20);
    tempDisplay.setFont(bigFont);
    showTemp();

    centerPanel = new Panel();
    centerPanel.setLayout (new FlowLayout() );
    centerPanel.add(tempDisplay);
    add (centerPanel, "Center");

     // south panel = two buttons

    minusButton = new Button(" -1");
    minusButton.addActionListener ( controller );
    minusButton.setActionCommand ("minus");

    plusButton = new Button("+1");
    plusButton.addActionListener ( controller );
    plusButton.setActionCommand ("plus");

    southPanel = new Panel();
    southPanel.setLayout (new FlowLayout() );
    southPanel.add(minusButton);
    southPanel.add(plusButton);
    add (southPanel, "South");

    setVisible(true);
  }

  protected void showTemp() {
    int temp = model.getTemp();
    tempDisplay.setBackground(Color.white);
    if (temp<20) {
      tempDisplay.setForeground(Color.blue);
    }
    else if (temp>25) {
      tempDisplay.setForeground(Color.red);
    }
    else {
      tempDisplay.setForeground(Color.magenta);
    } 
    tempDisplay.setText("" + temp);
  }
}
