import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

public class TrafficLight extends Applet
  implements ActionListener {

  private Label titleLabel;
  private TheLight theLight; // defined below
  private Button nextButton, stopButton;
  private Panel northPanel, centerPanel, southPanel;

  public void init () {

    theLight = new TheLight();

    setLayout (new BorderLayout() );

    // north panel = title label

    northPanel = new Panel();
    northPanel.setLayout (new FlowLayout() );
    titleLabel = new Label ("Traffic Light Exercise ");
    northPanel.add(titleLabel);
    add (northPanel, "North");

    // center panel = traffic light drawing canvas

    centerPanel = new Panel();
    centerPanel.setLayout (new FlowLayout() );
    centerPanel.add(theLight);
    add (centerPanel, "Center");

    // south panel = two buttons

    nextButton = new Button("Next");
    nextButton.addActionListener (this);
    nextButton.setActionCommand ("next");

    stopButton = new Button("Stop");
    stopButton.addActionListener (this);
    stopButton.setActionCommand ("stop");

    southPanel = new Panel();
    southPanel.setLayout (new FlowLayout() );
    southPanel.add(nextButton);
    southPanel.add(stopButton);
    add (southPanel, "South");

    setVisible(true);
  }

  public void actionPerformed (ActionEvent e) {
    String which = (String) e.getActionCommand();
    if ( which.equals("next") ) {
      theLight.nextState();
      theLight.repaint();
    }
    if ( which.equals("stop") ) {
      theLight.setState(TheLight.RED);
      theLight.repaint();
    }
  }
}
