class Tree {

  private static final boolean TEST = false;

  protected int x;
  protected int y;
  protected boolean isGood = true;
  protected boolean inHouse = false;
  protected boolean outOfGarden = false;
  protected boolean tooNear = false;

  private Planted planted;

  protected Tree (int x, int y, Planted p) {
    this.planted = p;
    setLocation (x, y);
  }

  protected void setLocation (int x, int y) {
    this.x = x;
    this.y = y;
    isGood = true;
    inHouse = false;
    outOfGarden = false;
    tooNear = false;
    if ( x<=10 || x>=190 || y<=10 || y>=190 ) {
      outOfGarden = true;
      isGood = false;
    }
    else
    if ( (x>=30 && x <=170) && (y>=10 && y<=90) ) {
      inHouse = true;
      isGood = false;
    }
    else
    if ( y<=110 ) {
      tooNear = true; /* too near to house */
      isGood = false;
    }
    else {
      for (int i=0; i<planted.numTrees; i++) {
        int dx = x - planted.tree[i].x;
        int dy = y - planted.tree[i].y;
        if ( Math.sqrt ( dx*dx + dy*dy ) < 40 ) {
           tooNear = true; /* too near to planted tree */
           isGood = false;
        }
      }
    }
    if (TEST) {
      System.out.println("Tree  x=" + x + "  y=" + y + "  isGood=" + isGood);
    }
  }
}
