import java.io.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

public class WriteDom {

  private String indentation = ". ";
  private Document doc;
  private Element root;

  public void doit(String filename, String newfile) {
    try {
      File file = new File(filename);
      DocumentBuilderFactory factory =
        DocumentBuilderFactory.newInstance();
      DocumentBuilder builder =
        factory.newDocumentBuilder();
      doc = builder.parse( file );
      root = doc.getDocumentElement();
      addPerson("Richard", "Wagner", 1813, 0.0);
      writeFile(newfile);
    } catch (Exception e) {
        System.out.println(e);
    }
  }

  public void addPerson
      (String vorname, String zuname, int gebjahr, double gehalt) {

    Element person = doc.createElement("person");
    root.insertBefore( person, null ); // before null = at end

    Element el;
    Node text;

    el = doc.createElement("vorname");
    person.appendChild(el);
    text = doc.createTextNode( vorname );
    el.appendChild(text);

    el = doc.createElement("zuname");
    person.appendChild(el);
    text = doc.createTextNode( zuname );
    el.appendChild(text);

    el = doc.createElement("gebjahr");
    person.appendChild(el);
    text = doc.createTextNode( String.valueOf(gebjahr) );
    el.appendChild(text);

    el = doc.createElement("gehalt");
    person.appendChild(el);
    text = doc.createTextNode( String.valueOf(gehalt) );
    el.appendChild(text);

  }

  public void writeFile (String filename) throws Exception {
    PrintWriter out = new PrintWriter( new BufferedWriter(
      new FileWriter(filename)));
    String head = "<?xml version='1.0' encoding='ISO-8859-1'?>";
    out.println(head);
    String body = doc.getDocumentElement().toString();
    out.println(body);
    out.flush();
    out.close();
  }

  public static void main (String[] args) {
      WriteDom prog = new WriteDom();
      prog.doit("mitarbeiter.xml","new.xml");
  }

}
