import java.util.*;
import java.io.*;

public class Person implements Comparable, Serializable {

   private String vorname;
   private String zuname;

   public Person (String zuname, String vorname) {
      this.setZuname(zuname);
      this.setVorname(vorname);
   }

   protected void setZuname (String s) {
      this.zuname = s;
   }
   public String getZuname() {
      return this.zuname;
   }

   protected void setVorname (String s) {
      this.vorname = s;
   }
   public String getVorname() {
      return this.vorname;
   }

   public String toString() {
      return this.vorname + " " + this.zuname;
   }

   public boolean equals (Object other) {
      if (other==this) return true;
      if (other==null) return false;
      return ( other instanceof Person ) &&
      ( this.vorname .equals ( ((Person)other).vorname ) ) &&
      ( this.zuname .equals ( ((Person)other).zuname ) );
   }

   public int compareTo (Object other)
             throws ClassCastException {
      Person otherP = (Person)other; // ClassCastException
      if ( this.zuname .equals( otherP.zuname ) ) {
         return this.vorname .compareTo ( otherP.vorname );
      } else {
         return this.zuname .compareTo ( otherP.zuname );
      }
   }
}
